//////////
//
//	File:		QTUtilities.h
//
//	Contains:	Useful utilities for working with QuickTime movies.
//				All utilities start with the prefix "QTUtils_".
//
//	Written by:	Tim Monroe
//				Based heavily on the DTSQTUtilities package by Apple DTS.
//				This is essentially a subset of that package, revised for cross-platform use.
//
//	Copyright:	 1996-1998 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <1>	 	09/10/97	rtm		first file
//	   
//////////

#pragma once

// header files
#ifndef __QTUtilities__
#define __QTUtilities__

#ifndef __MOVIES__
#include <Movies.h>
#endif

#ifndef __GESTALT__
#include <Gestalt.h>
#endif

#include <Endian.h>
#include <Script.h>
#include <Printing.h>

// constants
// constants used for QTUtils_PrintMoviePICT
enum eQTUPICTPrinting {
	kPrintFrame				= 1, 
	kPrintPoster			= 2
};

// constants used for QTUtils_GetMovieFileLoopingInfo
enum {
	kNormalLooping				= 0, 
	kPalindromeLooping			= 1, 
	kNoLooping					= 2
};

#define kQTVideoEffectsMinVers		0x0300		// version of QT that first supports QT video effects
#define kQTFullScreenMinVers		0x0209		// version of QT that first supports full-screen calls
#define kQTWiredSpritesMinVers		0x0300		// version of QT that first supports wired sprites

// function prototypes

Boolean						QTUtils_IsQuickTimeInstalled (void); 
Boolean						QTUtils_IsQuickTimeCFMInstalled (void);
long						QTUtils_GetQTVersion (void);
Boolean						QTUtils_HasQuickTimeVideoEffects (void);
Boolean						QTUtils_HasFullScreenSupport (void);
Boolean						QTUtils_HasWiredSprites (void);
Movie						QTUtils_GetMovie (FSSpec *theFSSpec, short *theRefNum, short *theResID);
OSErr						QTUtils_SaveMovie (Movie theMovie);
Boolean						QTUtils_IsMediaTypeInMovie (Movie theMovie, OSType theMediaType);
Boolean						QTUtils_MovieHasSoundTrack (Movie theMovie);
MediaHandler				QTUtils_GetSoundMediaHandler (Movie theMovie);
OSErr						QTUtils_PrintMoviePICT (Movie theMovie, short x, short y, long PICTUsed);
OSErr						QTUtils_SelectAllMovie (MovieController mc);
ImageDescriptionHandle		QTUtils_MakeSampleDescription (long theEffectType, short theWidth, short theHeight);
OSErr						QTUtils_AddUserDataTextToMovie (Movie theMovie, char *theText, OSType theType);
OSErr						QTUtils_AddCopyrightToMovie (Movie theMovie, char *theText);
OSErr						QTUtils_AddMovieNameToMovie (Movie theMovie, char *theText);
OSErr						QTUtils_AddMovieInfoToMovie (Movie theMovie, char *theText);
OSErr						QTUtils_GetMovieFileLoopingInfo (Movie theMovie, long *theLoopInfo);
OSErr						QTUtils_SetMovieFileLoopingInfo (Movie theMovie, long theLoopInfo);
OSErr						QTUtils_SetLoopingStateFromFile (Movie theMovie, MovieController theMC);
void						QTUtils_ConvertFloatToBigEndian (float *theFloat);



#endif	// __QTUtilities__
